import { expect } from 'chai';
import { describe } from 'mocha';
import { deployContractsForTests, getSigners } from './helpers/deploy-helper';
import { Signers } from './types';
import { DataAccessPayAsYouGo } from '../../types';

describe('60 - Data Access Pay As You Go ERC1155 Contract Test', function () {
  let contract: DataAccessPayAsYouGo;
  let signers: Signers;
  beforeEach(async function () {
    contract = (await deployContractsForTests()).dataAccessPayAsYouGoContract;
    signers = await getSigners();
  });

  describe('Basic tests:', function () {
    it('contract can be deployed', async function () {
      await expect(contract).to.exist;
    });
    it('token should have name PayAsYouGo', async function () {
      await expect(await contract.name()).is.equal('PayAsYouGo');
    });

    it('token should have PAYG symbol', async function () {
      await expect(await contract.symbol()).is.equal('PAYG');
    });
  });

  describe('URI functionality', function () {
    it('should have initial URI', async function () {
      expect(await contract.uri(0)).to.equal('');
    });

    it('owner can set new URI', async function () {
      const newURI = 'https://newuri.com';
      await contract.setURI(newURI);
      expect(await contract.uri(0)).to.equal(newURI);
    });

    it('only owner can set new URI', async function () {
      const newURI = 'https://newuri.com';
      await expect(
        contract.connect(signers.signer1).setURI(newURI),
      ).to.be.revertedWith('Ownable: caller is not the owner');
    });
  });

  describe('contract extends OpenZeppelin Ownable ', function () {
    it('should check contract owner', async function () {
      expect(await contract.owner()).to.equal(signers.admin.address);
    });
    it('owner can change the owner', async function () {
      await contract.transferOwnership(signers.signer1.address);
      expect(await contract.owner()).to.equal(signers.signer1.address);
    });
  });
});
